#@package: neocanvas create_scrollable_canvas

#
# $Id: neocanvas.tcl,v 1.1.1.1 1999/03/31 20:34:39 damon Exp $
#

package require Tk

#
# Copyright (C) 1992-1997 NeoSoft.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies.  NeoSoft makes no 
# representations about the suitability of this software for any purpose.
# It is provided "as is" without express or implied warranty.

proc create_scrollable_canvas {w} {

    frame $w
    canvas $w.canvas -yscroll "$w.yscroll set" -xscroll "$w.xscroll set" \
        -width 15c -height 5c -relief sunken

    scrollbar $w.yscroll -relief sunken \
        -command "$w.canvas yview"

    scrollbar $w.xscroll -relief sunken -orient horiz \
        -command "$w.canvas xview"

    pack $w.xscroll -side bottom -fill x
    pack $w.yscroll -side right -fill y
    pack $w.canvas -in $w -expand yes -fill both
    pack $w -side top -expand yes -fill both
    return $w
}

