/*
 *
 * neoCbuf.h:  the definition of Neo_CursorPool
 * $Id: neoCbuf.h,v 1.1.1.1 1999/03/31 20:34:37 damon Exp $
 *
 */

typedef struct {
    int		res_max;
    int		res_hardmax;
    int		res_count;
    int		res_last;
    void	**results;
} Neo_CursorPool;

/* Neo_initCursorBuf:  creates the generic cursor buffer */
void Neo_initCursorBuf(Neo_CursorPool *pool, int startsize, int hardmax);

/* Neo_SetCursor:
 *   res is a pointer to the item you want to store in the buffer
 *   handle is a string that the id will be tacked on to, so
 *      if you pass "db0" as handle, it will set "db0.1" as the Tcl result
 */
int Neo_SetCursor(Tcl_Interp *interp, Neo_CursorPool *pool,
	void *res, char *handle);

/* Neo_GetCursor:
 *   given a pool and an integer, it will return that item
 */
void * Neo_GetCursor(Neo_CursorPool *pool, int id);

/* Neo_DelCursor:
 *   given a pool and an integer, it will delete that item
 */
void Neo_DelCursor(Neo_CursorPool *pool, int id);
